package net.bluemind.cql.schemas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyspaceDescriptors {

	private static final Logger logger = LoggerFactory.getLogger(KeyspaceDescriptors.class);
	private static final List<CqlKeyspaceDescriptor> spaces = loadSpaces();

	private KeyspaceDescriptors() {
	}

	private static List<CqlKeyspaceDescriptor> loadSpaces() {
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("net.bluemind.cql.schemas",
				"keyspace");

		IExtension[] extensions = point.getExtensions();
		List<CqlKeyspaceDescriptor> descs = new ArrayList<>();
		for (IExtension ie : extensions) {
			Bundle bundle = Platform.getBundle(ie.getContributor().getName());
			logger.info("loading keyspaces from bundle: {}", bundle.getSymbolicName());

			for (IConfigurationElement e : ie.getConfigurationElements()) {
				if (e.getName().equals("keyspace")) {

					descs.add(new CqlKeyspaceDescriptor(e.getAttribute("identifier")));
				}
			}
		}
		return Collections.unmodifiableList(descs);
	}

	public static List<CqlKeyspaceDescriptor> keyspaces() {
		return spaces;
	}

}
