package net.bluemind.cql.node.service;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider.IServerSideServiceFactory;
import net.bluemind.cql.node.api.ICqlNode;

public class CqlNodeServiceFactory implements IServerSideServiceFactory<ICqlNode> {

	@Override
	public Class<ICqlNode> factoryClass() {
		return ICqlNode.class;
	}

	@Override
	public ICqlNode instance(BmContext context, String... params) throws ServerFault {
		return new CqlNodeService(context);
	}

}
