/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.task.api.ITask.
 */

goog.provide('net.bluemind.core.task.api.TaskClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.task.api.ITask API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} taskId
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.task.api.TaskClient = function(rpc, base , taskId ) {
  goog.base(this, rpc, base);
  this.base += '/tasks/{taskId}';
   this.taskId_ = taskId;
   this.base = this.base.replace('{taskId}',goog.string.urlEncode(taskId));
};

goog.inherits(net.bluemind.core.task.api.TaskClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} taskId
 * @private
 */
net.bluemind.core.task.api.TaskClient.prototype.taskId_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} offset
 * @return {Object}
 */
net.bluemind.core.task.api.TaskClient.prototype.getCurrentLogs = function( offset  ) {

  var postUri = "/_currentLogs";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(offset)) {
    url.getQueryData().add('offset', offset);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getCurrentLogs_" 
                                  + this.taskId_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.task.api.TaskClient.prototype.log = function() {

  var postUri = "/_log";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "log_" 
                                  + this.taskId_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.task.api.TaskClient.prototype.status = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "status_" 
                                  + this.taskId_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

