/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.task.api.ITask.
 */

goog.provide('net.bluemind.core.task.api.TaskVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.task.api.ITask API.
 * @param {string sessionId} sessionId
*  @param {string} taskId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.task.api.TaskVertxClient = function( sessionId , taskId ) {
  this.sessionId = sessionId;
  this.base = '/tasks/{taskId}';
  this.taskId_ = taskId;
  this.base = this.base.replace('{taskId}',goog.string.urlEncode(taskId));
};

goog.inherits(net.bluemind.core.task.api.TaskVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} taskId
 * @private
 */
net.bluemind.core.task.api.TaskVertxClient.prototype.taskId_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} offset
 * @return {Object}
 */
net.bluemind.core.task.api.TaskVertxClient.prototype.getCurrentLogs = function( offset  ) {

  var postUri = "/_currentLogs";

  var params = {};

  if (goog.isDefAndNotNull(offset)) {
    params['offset'] = offset;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.task.api.TaskVertxClient.prototype.log = function() {

  var postUri = "/_log";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.task.api.TaskVertxClient.prototype.status = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

