/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.service.acl;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.sanitizer.ISanitizer;
import net.bluemind.core.sanitizer.ISanitizerFactory;
import net.bluemind.directory.api.BaseDirEntry.Kind;
import net.bluemind.mailbox.api.IMailboxAclUids;

public class SharedMailboxAclSanitizer implements ISanitizer<SharedMailboxUpdateAcl> {
	public static class SharedMailboxAclSanitizerFactory implements ISanitizerFactory<SharedMailboxUpdateAcl> {

		@Override
		public Class<SharedMailboxUpdateAcl> support() {
			return SharedMailboxUpdateAcl.class;
		}

		@Override
		public ISanitizer<SharedMailboxUpdateAcl> create(BmContext context, Container container) {
			return new SharedMailboxAclSanitizer(context, container);
		}

	}

	private final BmContext context;
	private final Container container;

	public SharedMailboxAclSanitizer(BmContext context, Container container) {
		this.context = context;
		this.container = container;
	}

	@Override
	public void create(SharedMailboxUpdateAcl obj) {
		// OK
	}

	@Override
	public void update(SharedMailboxUpdateAcl previous, SharedMailboxUpdateAcl current) {
		if (!container.type.equals(IMailboxAclUids.TYPE)) {
			return;
		}

		if (current.dirEntryKind() != Kind.MAILSHARE && current.dirEntryKind() != Kind.SHARED_MAILBOX) {
			return;
		}

		SharedMailboxAclManager sharedMailboxAclManager = new SharedMailboxAclManager(previous.acl(), current.acl(),
				current.dirEntryKind());
		sharedMailboxAclManager.updateDelegationAccess(context, container);

	}

}
