/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.service.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.api.fault.ErrorCode;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.IOfflineMgmt;
import net.bluemind.core.container.api.IdRange;
import net.bluemind.core.container.repository.IOfflineMgmtStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.repository.provider.RepositoryProvider;

public class OfflineMgmtService implements IOfflineMgmt {

	private static final Logger logger = LoggerFactory.getLogger(OfflineMgmtService.class);

	private final IOfflineMgmtStore store;

	public OfflineMgmtService(BmContext ctx, DirEntry de) {
		this.store = RepositoryProvider.instance(IOfflineMgmtStore.class, ctx, de);
	}

	@Override
	public IdRange allocateOfflineIds(int idCount) {
		long startValue = ServerFault.onException(() -> store.reserveItemIds(idCount), ErrorCode.SQL_ERROR);
		logger.debug("Allocated {} local replica ids, starting at {}", idCount, startValue);
		return IdRange.create(idCount, startValue);
	}

}
