/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2016
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.service.internal;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.internal.IInternalContainerSync;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ContainerSyncResult;
import net.bluemind.core.container.model.ContainerSyncStatus;
import net.bluemind.core.container.repository.IContainerSyncStore;
import net.bluemind.core.container.sync.SyncableContainer;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.task.service.NullTaskMonitor;
import net.bluemind.repository.provider.RepositoryProvider;

public class InternalContainerSyncService implements IInternalContainerSync {

	private BmContext context;
	private Container container;
	private IContainerSyncStore containerSyncStore;

	public InternalContainerSyncService(BmContext context, Container container) {
		this.context = context;
		this.container = container;

		containerSyncStore = RepositoryProvider.instance(IContainerSyncStore.class, context, container);
	}

	@Override
	public ContainerSyncResult sync() throws ServerFault {
		ContainerSyncStatus ss = containerSyncStore.getSyncStatus();
		SyncableContainer syncableContainer = new SyncableContainer(context);
		ContainerSyncResult res = syncableContainer.sync(container, ss.syncTokens, new NullTaskMonitor());
		if (res != null) {
			containerSyncStore.setSyncStatus(res.status);
		}
		return res;
	}

}
