package net.bluemind.core.container.service.internal;

import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.container.api.IChangesetCleanup;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IChangesetCleanupStore;
import net.bluemind.core.jdbc.JdbcAbstractStore;
import net.bluemind.core.jdbc.JdbcAbstractStore.SqlOperation;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.RepositoryProvider;

public class ChangesetCleanupService implements IChangesetCleanup {

	private static final Logger logger = LoggerFactory.getLogger(ChangesetCleanupService.class);

	private IChangesetCleanupStore changetsetCleanupStore;

	public ChangesetCleanupService(BmContext ctx, DataLocation location) {
		this.changetsetCleanupStore = RepositoryProvider.instance(IChangesetCleanupStore.class, ctx, location);
	}

	public <W> W doOrFail(SqlOperation<W> op) {
		return JdbcAbstractStore.doOrFail(op);
	}

	@Override
	public void deleteOldDeletedChangesetItems(int days) {
		JdbcAbstractStore.doOrFail(() -> {
			logger.info("Expiring changeset old items ({} days)", days);
			try {
				long deletedItems = changetsetCleanupStore.deleteExpiredItems(days);
				logger.info("Expired {} changeset old items", deletedItems);
			} catch (SQLException e) {
				logger.error("Error cleaning up changeset items  {}", e.getMessage());
			}
			return null;
		});
	}

}
