package net.bluemind.core.container.service;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.ISharedContainers;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.directory.api.IDirectory;

public class SharedContainersFactory implements ServerSideServiceProvider.IServerSideServiceFactory<ISharedContainers> {

	@Override
	public Class<ISharedContainers> factoryClass() {
		return ISharedContainers.class;
	}

	@Override
	public ISharedContainers instance(BmContext context, String... params) throws ServerFault {

		if (params == null || params.length < 2) {
			throw new ServerFault("wrong number of instance parameters");
		}

		String domainUid = params[0];
		String ownerUid = params[1];

		IDirectory dirApi = context.provider().instance(IDirectory.class, domainUid);

		return new SharedContainersService(context, dirApi, ownerUid);
	}

}
