/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.service.internal;

import java.util.ArrayList;
import java.util.List;

public class ComposedRbacManager implements IComposeRbacManager {

	List<RBACManager> managers = new ArrayList<>();

	public ComposedRbacManager(List<RBACManager> rbac) {
		this.managers.addAll(rbac);
	}

	@Override
	public boolean can(String... roles) {
		for (RBACManager rbacManager : managers) {
			if (rbacManager.can(roles)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public void check(String... roles) {
		if (!can(roles)) {
			for (RBACManager rbacManager : managers) {
				rbacManager.check(roles);
			}
		}
	}
}
