/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.acl.AccessControlEntry;

public interface IAclStore {

	/**
	 * Replace existing ACLs with the given ones
	 * 
	 * @param container
	 * @param entries
	 * @throws SQLException
	 * @throws ServerFault
	 */
	void store(final Container container, List<AccessControlEntry> entries) throws ServerFault;

	void add(final Container container, List<AccessControlEntry> entries) throws SQLException;

	List<AccessControlEntry> get(Container container) throws SQLException;

	void deleteAll(Container container) throws SQLException;

	List<AccessControlEntry> retrieveAndStore(Container container, List<AccessControlEntry> entries) throws ServerFault;
}
