/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.core.container.api.ContainerQuery;
import net.bluemind.core.container.model.Container;

public interface IContainerStore {

	List<Container> findByContainerQuery(ContainerQuery containerquery) throws SQLException;

	List<Container> findByType(String containerType) throws SQLException;

	List<Container> findAccessiblesByType(ContainerQuery query) throws SQLException;

	Container create(Container container) throws SQLException;

	void update(String uid, String name, boolean defaultContainer) throws SQLException;

	Container get(String uid) throws SQLException;

	boolean exists(String uid) throws SQLException;

	Container get(long id) throws SQLException;

	void delete(String uid) throws SQLException;

	void delete(Container existing) throws SQLException;

	void deleteAllSubscriptions(Container container) throws SQLException;

	List<String> listSubscriptions(Container container) throws SQLException;

}