/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.repository;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import net.bluemind.core.container.api.Count;
import net.bluemind.core.container.model.CountFastPath;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.model.ItemFlag;
import net.bluemind.core.container.model.ItemFlagFilter;
import net.bluemind.core.container.model.ItemVersion;

public interface IItemStore {

	Item create(Item item) throws SQLException;

	long count(ItemFlagFilter filter) throws SQLException;

	Item setExtId(String uid, String extId) throws SQLException;

	default Item update(String uid, String displayName) throws SQLException {
		return update(uid, displayName, Collections.emptyList());
	}

	Item update(String uid, String displayName, Collection<ItemFlag> flags) throws SQLException;

	Item update(Item item, String displayName, Collection<ItemFlag> flags) throws SQLException;

	Item update(long id, String displayName, Collection<ItemFlag> flags) throws SQLException;

	void touchContainer(ItemVersion version) throws SQLException;

	Item touch(String uid) throws SQLException;

	Item get(String uid) throws SQLException;

	default Long getItemId(String uid) throws SQLException {
		Item it = get(uid);
		if (it == null) {
			return null;
		}
		return it.id;
	}

	Item getByExtId(String extId) throws SQLException;

	Item getById(long id) throws SQLException;

	List<Item> getMultiple(List<String> uids) throws SQLException;

	List<Item> getMultipleById(List<Long> uids) throws SQLException;

	List<Item> all() throws SQLException;

	int getItemCount() throws SQLException;

	default Optional<Count> fastpathCount(CountFastPath fastPath) {
		return Optional.empty();
	}

	void delete(Item item) throws SQLException;

	void deleteAll() throws SQLException;

	List<String> allItemUids() throws SQLException;

	List<Long> allItemIds() throws SQLException;

	long getVersion() throws SQLException;

}