/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

import net.bluemind.core.container.model.Item;

public interface IItemValueStore<T> {

	public void create(Item item, T value) throws SQLException;

	public void update(Item item, T value) throws SQLException;

	public void delete(Item item) throws SQLException;

	public T get(Item item) throws SQLException;

	default T getLight(Item item) throws SQLException {
		return get(item);
	}

	default T getCustom(Item item, List<? extends ICustomDecorator> decoratorNames) throws SQLException {
		return get(item);
	}

	public void deleteAll() throws SQLException;

	default List<T> getMultiple(List<Item> items) throws SQLException {
		return items.stream().map(i -> {
			try {
				return get(i);
			} catch (SQLException sqle) {
				return null;
			}
		}).filter(Objects::nonNull).toList();
	}

	default List<T> getMultipleCustom(List<Item> items, List<? extends ICustomDecorator> decoratorNames)
			throws SQLException {
		return getMultiple(items);
	}

	public boolean exists(Item item) throws SQLException;
}
