/* BEGIN LICENSE
* Copyright © Blue Mind SAS, 2012-2024
*
* This file is part of BlueMind. BlueMind is a messaging and collaborative
* solution.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of either the GNU Affero General Public License as
* published by the Free Software Foundation (version 3 of the License).
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* See LICENSE.txt
* END LICENSE
*/

package net.bluemind.core.container.persistence.factories;

import javax.sql.DataSource;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.persistence.SharedContainerStore;
import net.bluemind.core.container.repository.ISharedContainerStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.IDataLocationBoundFactory;

public class SharedContainerStoreFactory implements IDataLocationBoundFactory<ISharedContainerStore> {

	@Override
	public Class<ISharedContainerStore> factoryClass() {
		return ISharedContainerStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	private ISharedContainerStore get(BmContext context, String serverUidOrNull) throws ServerFault {
		DataSource ds = context.getDataSource();
		if (serverUidOrNull != null) {
			DataSource tmpDs = context.getMailboxDataSource(serverUidOrNull);
			if (tmpDs != null) {
				ds = tmpDs;
			}
		}
		return new SharedContainerStore(context, ds);
	}

	@Override
	public ISharedContainerStore instance(BmContext context, DataLocation dataLocation) throws ServerFault {
		return get(context, dataLocation.serverUid());
	}

}
