/* BEGIN LICENSE
* Copyright © Blue Mind SAS, 2012-2024
*
* This file is part of BlueMind. BlueMind is a messaging and collaborative
* solution.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of either the GNU Affero General Public License as
* published by the Free Software Foundation (version 3 of the License).
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* See LICENSE.txt
* END LICENSE
*/

package net.bluemind.core.container.persistence.factories;

import javax.sql.DataSource;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.persistence.OfflineMgmtStore;
import net.bluemind.core.container.repository.IOfflineMgmtStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.repository.provider.IOwnerBoundFactory;

public class OfflineMgmtStoreFactory implements IOwnerBoundFactory<IOfflineMgmtStore> {

	@Override
	public Class<IOfflineMgmtStore> factoryClass() {
		return IOfflineMgmtStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IOfflineMgmtStore instance(BmContext context, DirEntry de) throws ServerFault {
		DataSource ds = de == null || de.dataLocation == null || "dir".equals(de.dataLocation)
				|| context.getMailboxDataSource(de.dataLocation) == null ? context.getDataSource()
						: context.getMailboxDataSource(de.dataLocation);
		return new OfflineMgmtStore(ds);
	}

}
