/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.persistence;

import java.sql.SQLException;

import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerRouteStore;
import net.bluemind.core.jdbc.JdbcAbstractStore;
import net.bluemind.core.rest.BmContext;

public class ContainerRouteStore extends JdbcAbstractStore implements IContainerRouteStore {

	private final BmContext ctx;

	public ContainerRouteStore(BmContext ctx) {
		super(ctx.getDataSource());
		this.ctx = ctx;
	}

	@Override
	public DataLocation routeOf(ContainerUid cUid) {
		return DataLocation.of(DataSourceRouter.location(ctx, cUid.value()));
	}

	@Override
	public void storeRoute(ContainerUid cUid, DataLocation route) throws SQLException {
		insert("INSERT INTO t_container_location VALUES (?, ?) ON CONFLICT (container_uid) DO UPDATE SET location = ? WHERE t_container_location.container_uid = ?",
				cUid, (con, statement, index, currentRow, value) -> {

					statement.setString(index++, value.value());
					statement.setString(index++, route.serverUid());
					statement.setString(index++, route.serverUid());
					statement.setString(index++, value.value());

					return index;
				});
		DataSourceRouter.invalidateContainer(cUid.value());
	}

	@Override
	public void deleteRoute(ContainerUid cUid) throws SQLException {
		delete("DELETE FROM t_container_location WHERE container_uid=?", new Object[] { cUid.value() });
		DataSourceRouter.invalidateContainer(cUid.value());
	}

}
