<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerQuery.
 */
class ContainerQuery  {

  /*
   * @type String
   */
  public $type;

  /*
   * @type String
   */
  public $name;

  /*
   * @type List
   */
  public $verb;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type Boolean
   */
  public $readonly;

  /*
   * @type int
   */
  public $size;

  /*
   * Constructor
   */
  public function __construct() {
    $this->type = "";
    $this->name = "";
    $this->verb =  array();
    $this->owner = "";
    $this->readonly = false;
    $this->size = 0;
  }

  public function toMap() {
    $data = array(    
        "type" => empty($this->type) ? null : $this->type,    
        "name" => empty($this->name) ? null : $this->name,    
        "verb" => empty($this->verb) ? null : $this->verb,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "readonly" => empty($this->readonly) ? null : $this->readonly,    
        "size" => empty($this->size) ? null : $this->size);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
