<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerChangeset.
 */
class ContainerChangeset  {

  /*
   * @type List
   */
  public $created;

  /*
   * @type List
   */
  public $updated;

  /*
   * @type List
   */
  public $deleted;

  /*
   * @type long
   */
  public $version;

  /*
   * Constructor
   */
  public function __construct() {
    $this->created =  array();
    $this->updated =  array();
    $this->deleted =  array();
    $this->version = 0;
  }

  public function toMap() {
    $data = array(    
        "created" => empty($this->created) ? null : $this->created,    
        "updated" => empty($this->updated) ? null : $this->updated,    
        "deleted" => empty($this->deleted) ? null : $this->deleted,    
        "version" => empty($this->version) ? null : $this->version);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
