<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerSubscriptionModel.
 */
class ContainerSubscriptionModel extends ContainerSubscription {

  /*
   * @type String
   */
  public $containerType;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type boolean
   */
  public $defaultContainer;

  /*
   * @type String
   */
  public $name;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->containerType = "";
    $this->owner = "";
    $this->defaultContainer = false;
    $this->name = "";
  }

  public function toMap() {
    $data = array(    
        "containerType" => empty($this->containerType) ? null : $this->containerType,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "defaultContainer" => empty($this->defaultContainer) ? null : $this->defaultContainer,    
        "name" => empty($this->name) ? null : $this->name);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
