/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.ISortingSupport.
 */

goog.provide('net.bluemind.core.container.api.SortingSupportClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.ISortingSupport API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.SortingSupportClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '';
};

goog.inherits(net.bluemind.core.container.api.SortingSupportClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {Object} sorted
 * @return {Object}
 */
net.bluemind.core.container.api.SortingSupportClient.prototype.sortedIds = function( sorted  ) {

  var postUri = "/_sorted";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "sortedIds_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = sorted;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} sorted
 * @return {Object}
 */
net.bluemind.core.container.api.SortingSupportClient.prototype.sortedUids = function( sorted  ) {

  var postUri = "/_sorteduids";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "sortedUids_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = sorted;
  return this.execute(cmd, body);
};

