/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IOwnerSubscriptions.
 */

goog.provide('net.bluemind.core.container.api.OwnerSubscriptionsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IOwnerSubscriptions API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
*  @param {string} ownerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient = function(rpc, base , domainUid , ownerUid ) {
  goog.base(this, rpc, base);
  this.base += '/containers/_subscriptions/{domainUid}/{ownerUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
   this.ownerUid_ = ownerUid;
   this.base = this.base.replace('{ownerUid}',goog.string.urlEncode(ownerUid));
};

goog.inherits(net.bluemind.core.container.api.OwnerSubscriptionsClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.domainUid_;
/**
 * @type {string} ownerUid
 * @private
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.ownerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "changeset_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "changesetById_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} filter
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.filteredChangesetById = function( since ,  filter  ) {

  var postUri = "/_filteredChangesetById";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "filteredChangesetById_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = filter;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.fullChangesetById = function( since  ) {

  var postUri = "/_fullChangesetById";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "fullChangesetById_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.getCompleteById = function( id  ) {

  var postUri = "/{id}/completeById";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getCompleteById_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.getMultiple = function( uids  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getMultiple_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.getVersion = function() {

  var postUri = "/_version";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getVersion_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.list = function() {

  var postUri = "/_list";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "list_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} ids
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionsClient.prototype.multipleGetById = function( ids  ) {

  var postUri = "/_mgetById";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "multipleGetById_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = ids;
  return this.execute(cmd, body);
};

