/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IOfflineMgmt.
 */

goog.provide('net.bluemind.core.container.api.OfflineMgmtVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IOfflineMgmt API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
*  @param {string} ownerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.OfflineMgmtVertxClient = function( sessionId , domainUid , ownerUid ) {
  this.sessionId = sessionId;
  this.base = '/offline/{domainUid}/{ownerUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
  this.ownerUid_ = ownerUid;
  this.base = this.base.replace('{ownerUid}',goog.string.urlEncode(ownerUid));
};

goog.inherits(net.bluemind.core.container.api.OfflineMgmtVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.core.container.api.OfflineMgmtVertxClient.prototype.domainUid_;
/**
 * @type {string} ownerUid
 * @private
 */
net.bluemind.core.container.api.OfflineMgmtVertxClient.prototype.ownerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} idCount
 * @return {Object}
 */
net.bluemind.core.container.api.OfflineMgmtVertxClient.prototype.allocateOfflineIds = function( idCount  ) {

  var postUri = "/_allocateOfflineIds";

  var params = {};

  if (goog.isDefAndNotNull(idCount)) {
    params['idCount'] = idCount;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

