/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IOfflineMgmt.
 */

goog.provide('net.bluemind.core.container.api.OfflineMgmtClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IOfflineMgmt API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
*  @param {string} ownerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.OfflineMgmtClient = function(rpc, base , domainUid , ownerUid ) {
  goog.base(this, rpc, base);
  this.base += '/offline/{domainUid}/{ownerUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
   this.ownerUid_ = ownerUid;
   this.base = this.base.replace('{ownerUid}',goog.string.urlEncode(ownerUid));
};

goog.inherits(net.bluemind.core.container.api.OfflineMgmtClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.core.container.api.OfflineMgmtClient.prototype.domainUid_;
/**
 * @type {string} ownerUid
 * @private
 */
net.bluemind.core.container.api.OfflineMgmtClient.prototype.ownerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} idCount
 * @return {Object}
 */
net.bluemind.core.container.api.OfflineMgmtClient.prototype.allocateOfflineIds = function( idCount  ) {

  var postUri = "/_allocateOfflineIds";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(idCount)) {
    url.getQueryData().add('idCount', idCount);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "allocateOfflineIds_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

