/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IChangesetCleanup.
 */

goog.provide('net.bluemind.core.container.api.ChangesetCleanupVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IChangesetCleanup API.
 * @param {string sessionId} sessionId
*  @param {string} serverUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ChangesetCleanupVertxClient = function( sessionId , serverUid ) {
  this.sessionId = sessionId;
  this.base = '/changeset_cleanup/{serverUid}';
  this.serverUid_ = serverUid;
  this.base = this.base.replace('{serverUid}',goog.string.urlEncode(serverUid));
};

goog.inherits(net.bluemind.core.container.api.ChangesetCleanupVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} serverUid
 * @private
 */
net.bluemind.core.container.api.ChangesetCleanupVertxClient.prototype.serverUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} days
 * @return {Object}
 */
net.bluemind.core.container.api.ChangesetCleanupVertxClient.prototype.deleteOldDeletedChangesetItems = function( days  ) {

  var postUri = "/_delete_old_changeset_items";

  var params = {};

  if (goog.isDefAndNotNull(days)) {
    params['days'] = days;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

