/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.ISortingSupport.
 */

goog.provide('net.bluemind.core.container.api.SortingSupportVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.ISortingSupport API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.SortingSupportVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '';
};

goog.inherits(net.bluemind.core.container.api.SortingSupportVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {Object} sorted
 * @return {Object}
 */
net.bluemind.core.container.api.SortingSupportVertxClient.prototype.sortedIds = function( sorted  ) {

  var postUri = "/_sorted";

  var params = {};



  var body = null;
  body = sorted;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} sorted
 * @return {Object}
 */
net.bluemind.core.container.api.SortingSupportVertxClient.prototype.sortedUids = function( sorted  ) {

  var postUri = "/_sorteduids";

  var params = {};



  var body = null;
  body = sorted;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

