/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IOwnerSubscriptionUids.
 */

goog.provide('net.bluemind.core.container.api.OwnerSubscriptionUidsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IOwnerSubscriptionUids API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.OwnerSubscriptionUidsVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/owner_subscriptions/uids';
};

goog.inherits(net.bluemind.core.container.api.OwnerSubscriptionUidsVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {string} domain
 * @return {Object}
 */
net.bluemind.core.container.api.OwnerSubscriptionUidsVertxClient.prototype.identifier = function( uid ,  domain  ) {

  var postUri = "/{uid}/{domain}/_subscription";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  postUri = postUri.replace("{domain}", goog.string.urlEncode(domain));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

