/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IInternalContainersByLocation.
 */

goog.provide('net.bluemind.core.container.api.InternalContainersByLocationClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IInternalContainersByLocation API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} location
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.InternalContainersByLocationClient = function(rpc, base , location ) {
  goog.base(this, rpc, base);
  this.base += '/containers/{location}/_by_location';
   this.location_ = location;
   this.base = this.base.replace('{location}',goog.string.urlEncode(location));
};

goog.inherits(net.bluemind.core.container.api.InternalContainersByLocationClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} location
 * @private
 */
net.bluemind.core.container.api.InternalContainersByLocationClient.prototype.location_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.InternalContainersByLocationClient.prototype.listByType = function( query  ) {

  var postUri = "/list_by_type";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "listByType_" 
                                  + this.location_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

