/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainers.
 */

goog.provide('net.bluemind.core.container.api.ContainersClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainers API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainersClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/containers/_manage';
};

goog.inherits(net.bluemind.core.container.api.ContainersClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.all = function( query  ) {

  var postUri = "/_list";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "all_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domainUid
 * @param {string} userUid
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.allForUser = function( domainUid ,  userUid ,  query  ) {

  var postUri = "/_listforuser";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(domainUid)) {
    url.getQueryData().add('domainUid', domainUid);
  }
  if (goog.isDefAndNotNull(userUid)) {
    url.getQueryData().add('userUid', userUid);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "allForUser_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.allLight = function( query  ) {

  var postUri = "/_listLight";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "allLight_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.create = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.exists = function( containerUid  ) {

  var postUri = "/_exists";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "exists_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  body = containerUid;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getAccessControlLists = function( containerIds  ) {

  var postUri = "/_macl";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAccessControlLists_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = containerIds;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getContainers = function( containerIds  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getContainers_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = containerIds;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getContainersLight = function( containerIds  ) {

  var postUri = "/_mgetLight";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getContainersLight_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = containerIds;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domainUid
 * @param {string} userUid
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getForUser = function( domainUid ,  userUid ,  uid  ) {

  var postUri = "/_forUser";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(domainUid)) {
    url.getQueryData().add('domainUid', domainUid);
  }
  if (goog.isDefAndNotNull(userUid)) {
    url.getQueryData().add('userUid', userUid);
  }
  if (goog.isDefAndNotNull(uid)) {
    url.getQueryData().add('uid', uid);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getForUser_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getIfPresent = function( uid  ) {

  var postUri = "/_ifPresent/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getIfPresent_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getLight = function( uid  ) {

  var postUri = "/_light/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getLight_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.getLightIfPresent = function( uid  ) {

  var postUri = "/_ifPresentLight/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getLightIfPresent_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<Object>} entries
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.setAccessControlList = function( uid ,  entries  ) {

  var postUri = "/{uid}/_acl";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setAccessControlList_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = entries;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersClient.prototype.update = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

