/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainerManagement.
 */

goog.provide('net.bluemind.core.container.api.ContainerManagementVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainerManagement API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainerManagementVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/containers/_manage/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.core.container.api.ContainerManagementVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.allowOfflineSync = function( subject  ) {

  var postUri = "/{subject}/offlineSync";

  postUri = postUri.replace("{subject}", goog.string.urlEncode(subject));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} verbsOrRoles
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.canAccess = function( verbsOrRoles  ) {

  var postUri = "/_canAccess";

  var params = {};



  var body = null;
  body = verbsOrRoles;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} verbsOrRoles
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.canAccessVerbs = function( verbsOrRoles  ) {

  var postUri = "/_canAccessVerbs";

  var params = {};



  var body = null;
  body = verbsOrRoles;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.disallowOfflineSync = function( subject  ) {

  var postUri = "/{subject}/offlineSync";

  postUri = postUri.replace("{subject}", goog.string.urlEncode(subject));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getAccessControlList = function() {

  var postUri = "/_acl";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getAllItems = function() {

  var postUri = "/_list";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getDescriptor = function() {

  var postUri = "/_descriptor";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getItemCount = function() {

  var postUri = "/_itemCount";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getItems = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.getSettings = function() {

  var postUri = "/_settings";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<Object>} entries
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.setAccessControlList = function( entries  ) {

  var postUri = "/_acl";

  var params = {};



  var body = null;
  body = entries;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.setPersonalSettings = function( settings  ) {

  var postUri = "/_personalSettings";

  var params = {};



  var body = null;
  body = settings;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} key
 * @param {string} value
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.setSetting = function( key ,  value  ) {

  var postUri = "/_settings/{key}";

  postUri = postUri.replace("{key}", goog.string.urlEncode(key));
  var params = {};



  var body = null;
  body = value;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.setSettings = function( settings  ) {

  var postUri = "/_settings";

  var params = {};



  var body = null;
  body = settings;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.subscribers = function() {

  var postUri = "/_subscription";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementVertxClient.prototype.update = function( descriptor  ) {

  var postUri = "/_descriptor";

  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

