/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.ISharedContainers.
 */

goog.provide('net.bluemind.core.container.api.SharedContainersVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.ISharedContainers API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
*  @param {string} ownerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.SharedContainersVertxClient = function( sessionId , domainUid , ownerUid ) {
  this.sessionId = sessionId;
  this.base = '/containers/{domainUid}/{ownerUid}/_shared';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
  this.ownerUid_ = ownerUid;
  this.base = this.base.replace('{ownerUid}',goog.string.urlEncode(ownerUid));
};

goog.inherits(net.bluemind.core.container.api.SharedContainersVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.core.container.api.SharedContainersVertxClient.prototype.domainUid_;
/**
 * @type {string} ownerUid
 * @private
 */
net.bluemind.core.container.api.SharedContainersVertxClient.prototype.ownerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} type
 * @return {Object}
 */
net.bluemind.core.container.api.SharedContainersVertxClient.prototype.getSharedContainers = function( type  ) {

  var postUri = "";

  var params = {};

  if (goog.isDefAndNotNull(type)) {
    params['type'] = type;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

