/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainers.
 */

goog.provide('net.bluemind.core.container.api.ContainersVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainers API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainersVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/containers/_manage';
};

goog.inherits(net.bluemind.core.container.api.ContainersVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.all = function( query  ) {

  var postUri = "/_list";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domainUid
 * @param {string} userUid
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.allForUser = function( domainUid ,  userUid ,  query  ) {

  var postUri = "/_listforuser";

  var params = {};

  if (goog.isDefAndNotNull(domainUid)) {
    params['domainUid'] = domainUid;
  }
  if (goog.isDefAndNotNull(userUid)) {
    params['userUid'] = userUid;
  }


  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.allLight = function( query  ) {

  var postUri = "/_listLight";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.create = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.exists = function( containerUid  ) {

  var postUri = "/_exists";

  var params = {};



  var body = null;
  body = containerUid;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getAccessControlLists = function( containerIds  ) {

  var postUri = "/_macl";

  var params = {};



  var body = null;
  body = containerIds;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getContainers = function( containerIds  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = containerIds;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} containerIds
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getContainersLight = function( containerIds  ) {

  var postUri = "/_mgetLight";

  var params = {};



  var body = null;
  body = containerIds;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domainUid
 * @param {string} userUid
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getForUser = function( domainUid ,  userUid ,  uid  ) {

  var postUri = "/_forUser";

  var params = {};

  if (goog.isDefAndNotNull(domainUid)) {
    params['domainUid'] = domainUid;
  }
  if (goog.isDefAndNotNull(userUid)) {
    params['userUid'] = userUid;
  }
  if (goog.isDefAndNotNull(uid)) {
    params['uid'] = uid;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getIfPresent = function( uid  ) {

  var postUri = "/_ifPresent/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getLight = function( uid  ) {

  var postUri = "/_light/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.getLightIfPresent = function( uid  ) {

  var postUri = "/_ifPresentLight/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<Object>} entries
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.setAccessControlList = function( uid ,  entries  ) {

  var postUri = "/{uid}/_acl";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = entries;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainersVertxClient.prototype.update = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

