/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainerSync.
 */

goog.provide('net.bluemind.core.container.api.ContainerSyncVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainerSync API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainerSyncVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/containers/_sync/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.core.container.api.ContainerSyncVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.core.container.api.ContainerSyncVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncVertxClient.prototype.getLastSync = function() {

  var postUri = "/_last";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncVertxClient.prototype.getNextSync = function() {

  var postUri = "/_next";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncVertxClient.prototype.getSyncStatus = function() {

  var postUri = "/_status";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncVertxClient.prototype.sync = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

