/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainerManagement.
 */

goog.provide('net.bluemind.core.container.api.ContainerManagementClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainerManagement API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainerManagementClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/containers/_manage/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.core.container.api.ContainerManagementClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.allowOfflineSync = function( subject  ) {

  var postUri = "/{subject}/offlineSync";

  postUri = postUri.replace("{subject}", goog.string.urlEncode(subject));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "allowOfflineSync_" 
                                  + this.containerUid_
                                  + subject
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} verbsOrRoles
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.canAccess = function( verbsOrRoles  ) {

  var postUri = "/_canAccess";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "canAccess_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = verbsOrRoles;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} verbsOrRoles
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.canAccessVerbs = function( verbsOrRoles  ) {

  var postUri = "/_canAccessVerbs";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "canAccessVerbs_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = verbsOrRoles;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.disallowOfflineSync = function( subject  ) {

  var postUri = "/{subject}/offlineSync";

  postUri = postUri.replace("{subject}", goog.string.urlEncode(subject));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "disallowOfflineSync_" 
                                  + this.containerUid_
                                  + subject
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getAccessControlList = function() {

  var postUri = "/_acl";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAccessControlList_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getAllItems = function() {

  var postUri = "/_list";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAllItems_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getDescriptor = function() {

  var postUri = "/_descriptor";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getDescriptor_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getItemCount = function() {

  var postUri = "/_itemCount";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getItemCount_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getItems = function( uids  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getItems_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.getSettings = function() {

  var postUri = "/_settings";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getSettings_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<Object>} entries
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.setAccessControlList = function( entries  ) {

  var postUri = "/_acl";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setAccessControlList_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = entries;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.setPersonalSettings = function( settings  ) {

  var postUri = "/_personalSettings";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setPersonalSettings_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = settings;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} key
 * @param {string} value
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.setSetting = function( key ,  value  ) {

  var postUri = "/_settings/{key}";

  postUri = postUri.replace("{key}", goog.string.urlEncode(key));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setSetting_" 
                                  + this.containerUid_
                                  + key
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = value;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.setSettings = function( settings  ) {

  var postUri = "/_settings";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setSettings_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = settings;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.subscribers = function() {

  var postUri = "/_subscription";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "subscribers_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerManagementClient.prototype.update = function( descriptor  ) {

  var postUri = "/_descriptor";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

