/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IChangesetCleanup.
 */

goog.provide('net.bluemind.core.container.api.ChangesetCleanupClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IChangesetCleanup API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} serverUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ChangesetCleanupClient = function(rpc, base , serverUid ) {
  goog.base(this, rpc, base);
  this.base += '/changeset_cleanup/{serverUid}';
   this.serverUid_ = serverUid;
   this.base = this.base.replace('{serverUid}',goog.string.urlEncode(serverUid));
};

goog.inherits(net.bluemind.core.container.api.ChangesetCleanupClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} serverUid
 * @private
 */
net.bluemind.core.container.api.ChangesetCleanupClient.prototype.serverUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} days
 * @return {Object}
 */
net.bluemind.core.container.api.ChangesetCleanupClient.prototype.deleteOldDeletedChangesetItems = function( days  ) {

  var postUri = "/_delete_old_changeset_items";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(days)) {
    url.getQueryData().add('days', days);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteOldDeletedChangesetItems_" 
                                  + this.serverUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

