/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.ISharedContainers.
 */

goog.provide('net.bluemind.core.container.api.SharedContainersClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.ISharedContainers API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
*  @param {string} ownerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.SharedContainersClient = function(rpc, base , domainUid , ownerUid ) {
  goog.base(this, rpc, base);
  this.base += '/containers/{domainUid}/{ownerUid}/_shared';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
   this.ownerUid_ = ownerUid;
   this.base = this.base.replace('{ownerUid}',goog.string.urlEncode(ownerUid));
};

goog.inherits(net.bluemind.core.container.api.SharedContainersClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.core.container.api.SharedContainersClient.prototype.domainUid_;
/**
 * @type {string} ownerUid
 * @private
 */
net.bluemind.core.container.api.SharedContainersClient.prototype.ownerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} type
 * @return {Object}
 */
net.bluemind.core.container.api.SharedContainersClient.prototype.getSharedContainers = function( type  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(type)) {
    url.getQueryData().add('type', type);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getSharedContainers_" 
                                  + this.domainUid_
                                  + this.ownerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

