/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IItemChangelogSupport.
 */

goog.provide('net.bluemind.core.container.api.ItemChangelogSupportClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IItemChangelogSupport API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ItemChangelogSupportClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '';
};

goog.inherits(net.bluemind.core.container.api.ItemChangelogSupportClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {number} since
 * @return {Object}
 */
net.bluemind.core.container.api.ItemChangelogSupportClient.prototype.itemChangelog = function( uid ,  since  ) {

  var postUri = "/{uid}/_itemchangelog";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "itemChangelog_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  body = since;
  return this.execute(cmd, body);
};

