/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IInternalContainersByLocation.
 */

goog.provide('net.bluemind.core.container.api.InternalContainersByLocationVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IInternalContainersByLocation API.
 * @param {string sessionId} sessionId
*  @param {string} location
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.InternalContainersByLocationVertxClient = function( sessionId , location ) {
  this.sessionId = sessionId;
  this.base = '/containers/{location}/_by_location';
  this.location_ = location;
  this.base = this.base.replace('{location}',goog.string.urlEncode(location));
};

goog.inherits(net.bluemind.core.container.api.InternalContainersByLocationVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} location
 * @private
 */
net.bluemind.core.container.api.InternalContainersByLocationVertxClient.prototype.location_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.core.container.api.InternalContainersByLocationVertxClient.prototype.listByType = function( query  ) {

  var postUri = "/list_by_type";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

