/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.core.container.api.IContainerSync.
 */

goog.provide('net.bluemind.core.container.api.ContainerSyncClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.core.container.api.IContainerSync API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.core.container.api.ContainerSyncClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/containers/_sync/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.core.container.api.ContainerSyncClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.core.container.api.ContainerSyncClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncClient.prototype.getLastSync = function() {

  var postUri = "/_last";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getLastSync_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncClient.prototype.getNextSync = function() {

  var postUri = "/_next";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getNextSync_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncClient.prototype.getSyncStatus = function() {

  var postUri = "/_status";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getSyncStatus_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.core.container.api.ContainerSyncClient.prototype.sync = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "sync_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

