/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.api;

import java.util.Collection;
import java.util.HashSet;

public class CollectionsEquivalent {
	private CollectionsEquivalent() {
	}

	public static <T> boolean areCollectionsEquivalent(Collection<T> c1, Collection<T> c2) {
		if (c1 == c2)
			return true;
		if (c1 == null && c2 != null)
			return false;
		if (c1 != null && c2 == null)
			return false;
		return new HashSet<>(c1).equals(new HashSet<>(c2));
	}
}
