<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VersionInfo.
 */
class VersionInfo  {

  /*
   * @type String
   */
  public $major;

  /*
   * @type String
   */
  public $minor;

  /*
   * @type String
   */
  public $release;

  /*
   * @type String
   */
  public $displayName;

  /*
   * Constructor
   */
  public function __construct() {
    $this->major = "";
    $this->minor = "";
    $this->release = "";
    $this->displayName = "";
  }

  public function toMap() {
    $data = array(    
        "major" => empty($this->major) ? null : $this->major,    
        "minor" => empty($this->minor) ? null : $this->minor,    
        "release" => empty($this->release) ? null : $this->release,    
        "displayName" => empty($this->displayName) ? null : $this->displayName);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
