package net.bluemind.core.backup.continuous.store;

import java.util.concurrent.CompletableFuture;

import io.vertx.core.json.JsonObject;
import net.bluemind.core.backup.continuous.IRecordStarvationStrategy;
import net.bluemind.core.backup.continuous.index.ISerde;
import net.bluemind.core.backup.continuous.index.IStreamLiveIndex;
import net.bluemind.core.backup.continuous.index.IPlanBuilder;
import net.bluemind.core.backup.continuous.store.ITopicStore.IResumeToken;

public interface TopicSubscriber {

	String topicName();

	IResumeToken parseToken(JsonObject js);

	IResumeToken subscribe(RecordHandler handler);

	IResumeToken subscribe(IResumeToken index, RecordHandler handler);

	IResumeToken subscribe(IResumeToken index, RecordHandler handler, IRecordStarvationStrategy strat);

	<K, V, K1, V1> CompletableFuture<IStreamLiveIndex<K1, V1>> index(String indexName,
			IPlanBuilder<K, V, K1, V1> buildPlan, ISerde<K> forKey, ISerde<V> forValue, ISerde<K1> forK1,
			ISerde<V1> forV1);

}