package net.bluemind.core.backup.continuous;

import java.util.concurrent.CompletableFuture;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import net.bluemind.core.backup.continuous.index.ISerde;
import net.bluemind.core.backup.continuous.index.IStreamLiveIndex;
import net.bluemind.core.backup.continuous.index.IPlanBuilder;
import net.bluemind.core.backup.continuous.store.ITopicStore.IResumeToken;

public interface ILiveStream {

	String fullName();

	IResumeToken parse(JsonObject js);

	IResumeToken subscribe(Handler<DataElement> handler);

	IResumeToken subscribe(IResumeToken startOffset, Handler<DataElement> handler);

	IResumeToken subscribe(IResumeToken startOffset, Handler<DataElement> handler, IRecordStarvationStrategy onStarve);

	String installationId();

	String domainUid();

	<K, V, K1, V1> CompletableFuture<IStreamLiveIndex<K1, V1>> index(String indexName,
			IPlanBuilder<K, V, K1, V1> buildPlan, ISerde<K> forK, ISerde<V> forV, ISerde<K1> forK1, ISerde<V1> forV1);

}