package net.bluemind.core.backup.continuous;

import com.google.common.base.MoreObjects;

import net.bluemind.core.backup.continuous.model.RecordKey;
import net.bluemind.core.backup.continuous.model.RecordKey.Operation;

public class DataElement {
	public RecordKey key;
	public byte[] payload;
	public int part;
	public long offset;

	public boolean isDelete() {
		return Operation.isDelete(key);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(DataElement.class)//
				.add("key", key)//
				.add("len", payload == null ? null : payload.length)//
				.toString();
	}
}