/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.index;

import java.util.List;
import java.util.function.BiPredicate;

public interface IIndexBuilder<K1, V1> {

	public record ReMapped<K, V>(K key, V value) {

	}

	public interface Mapper<K, V, K2, V2> {

		ReMapped<K2, V2> map(K key, V value);
	}

	public interface ListMapper<K, V, K2, V2> {

		List<ReMapped<K2, V2>> flatMap(K key, V value);
	}

	IIndexBuilder<K1, V1> filter(BiPredicate<K1, V1> pref);

	<K2, V2> IIndexBuilder<K2, V2> map(Mapper<K1, V1, K2, V2> mapper);

	<K2, V2> IIndexBuilder<K2, V2> flatMap(ListMapper<K1, V1, K2, V2> mapper);
}
