/*
 * BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
goog.provide("net.bluemind.contact.vcard.edit.ui.KeyField");

goog.require("goog.ui.Textarea");
goog.require("net.bluemind.contact.vcard.edit.ui.MultipleValueField");

/**
 * @constructor
 * 
 * @param {goog.ui.ControlContent} label
 * @param {*} options
 * @param {goog.ui.ControlRenderer=} opt_renderer
 * @param {goog.dom.DomHelper=} opt_domHelper
 * @extends {net.bluemind.contact.vcard.edit.ui.MultipleValueField}
 */ 
net.bluemind.contact.vcard.edit.ui.KeyField = function(label, opt_renderer, opt_domHelper) {
  net.bluemind.contact.vcard.edit.ui.MultipleValueField.call(this, label, opt_renderer, opt_domHelper);
  this.addClassName(goog.getCssName('field-key'));

}
goog.inherits(net.bluemind.contact.vcard.edit.ui.KeyField, net.bluemind.contact.vcard.edit.ui.MultipleValueField);

net.bluemind.contact.vcard.edit.ui.KeyField.prototype.enterDocument = function() {
  goog.base(this, 'enterDocument');

};


net.bluemind.contact.vcard.edit.ui.KeyField.prototype.resize_ = function() {
  if (this.isVisible()) {
    this.forEachChild(function(child) {
      if (child.getChild('field')) {
        child.getChild('field').resize()
      }
    });
  }
}

net.bluemind.contact.vcard.edit.ui.KeyField.prototype.setVisible = function(visible) {
  goog.base(this, 'setVisible',visible);
  this.resize_();
}

// net.bluemind.contact.vcard.edit.ui.KeyField.prototype.createFormField = function() {
//   var container = goog.base(this, 'createFormField');
//   if (container.getChild('field')) {
//     container.getChild('field').resize()
//   }
// }
net.bluemind.contact.vcard.edit.ui.KeyField.prototype.createInput = function() {
  var input = new goog.ui.Textarea();
  input.setMinHeight(48);
  input.setMaxHeight(100);
  return input;
};