/*
 * BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
goog.provide("net.bluemind.contact.vcard.edit.ui.CoordinateField");

goog.require("goog.ui.FlatMenuButtonRenderer");
goog.require("goog.ui.Menu");
goog.require("goog.ui.Select");
goog.require("net.bluemind.contact.vcard.edit.ui.MultipleValueField");

/**
 * @constructor
 * 
 * @param {goog.ui.ControlContent} label
 * @param {*} options
 * @param {goog.ui.ControlRenderer=} opt_renderer
 * @param {goog.dom.DomHelper=} opt_domHelper
 * @extends {net.bluemind.contact.vcard.edit.ui.MultipleValueField}
 */ 
net.bluemind.contact.vcard.edit.ui.CoordinateField = function(label, options, labelType, opt_renderer, opt_domHelper) {
  net.bluemind.contact.vcard.edit.ui.MultipleValueField.call(this, label, opt_renderer, opt_domHelper);
  this.options = options;
  this.labelType = labelType;
  this.addClassName(goog.getCssName('field-coordinate'));

}
goog.inherits(net.bluemind.contact.vcard.edit.ui.CoordinateField, net.bluemind.contact.vcard.edit.ui.MultipleValueField);

/**
 * @type {*}
 */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.options;


/** @override */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.addTrashIcon = function(container) {
  if (null != this.labelType){
		if (this.labelType == 'EMAIL'){
		  this.addCommunicationIcon(container, 'fa-paper-plane', 'mailto:');
		} else if (this.labelType == 'WEBSITE'){
		  this.addCommunicationIcon(container, 'fa-globe', 'http://');
		} else {
		  this.addCommunicationIcon(container, 'fa-phone', 'tel:');
		}
	}
  goog.base(this, 'addTrashIcon', container);


}

/**
 * Add mailto/tel icon
 * @param {goog.ui.Control} container
 * @param {string} css Icon css
 * @param {string} proto Default link protocol 
 */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.addCommunicationIcon = function(container, css, proto) {
	var elem = goog.dom.createDom('i', 
			goog.getCssName('coordinate-icon') + ' ' + goog.getCssName('goog-button-icon') + ' ' + goog.getCssName('fa') + ' ' + css);
	var href = goog.dom.createDom('a');
	if( goog.Uri.parse(container.getChildAt(1).getValue()).hasScheme()) {
	   href.href = container.getChildAt(1).getValue();
	} else {
    href.href = proto + container.getChildAt(1).getValue();

	}
  href.target = "_blank";
	goog.dom.appendChild(href, elem);
	goog.dom.appendChild(container.getElementByClass(goog.getCssName('field-base-field')), href);
}


/** @override */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.createLabel = function(container) {
  var menu = new goog.ui.Menu();
  var select = new goog.ui.Select(this.label, menu, goog.ui.FlatMenuButtonRenderer.getInstance());
  select.addClassName(goog.getCssName('goog-select'));
  
  var choiceArray = [];
  goog.object.forEach(this.options.STANDARD, function(msg, value) {
	if (!goog.array.contains(choiceArray, msg)){  
		select.addItem(new goog.ui.MenuItem(msg, value), true);
		goog.array.insert(choiceArray, msg);
	}
  });
  select.setId('label');

  
  container.addChild(select);
  select.render(container.getElementByClass(goog.getCssName('field-base-label')));

};


/** @override */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.setFieldValue = function(component, value) {
  this.setDataValue(component, value);
  this.setLabelValue(component, value);
};

net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.setDataValue = function(component, value) {
  component.getChild('field').setValue(value.value);
};

/**
 * @param {goog.ui.Component} component
 * @param {*} value
 */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.setLabelValue = function(component, value) {
  var msg;
  component.getChild('label').setValue(value.label);
  if (component.getChild('label').getSelectedIndex() == -1) {
    if ((msg = this.options.ALL[value.label])) {
      component.getChild('label').addItem(new goog.ui.MenuItem(msg, value.label), true);
    } else {
      msg = this.options.FALLBACK;
      component.getChild('label').addItem(new goog.ui.MenuItem(msg, value.label), true);
    }
    for (var i=0; i<component.getChild('label').getItemCount();i++){
    	if (component.getChild('label').getItemAt(i).getContent() == msg){
    	  component.getChild('label').setValue(component.getChild('label').getItemAt(i).getValue());
    	}
    }
    
  }
};



/** @override */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.getFieldValue = function(component) {
  var value = this.getDataValue(component);
  if (!!value && value != undefined) {
    return {value: value, label: this.getLabelValue(component)};
  }
  return undefined;
};

net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.getDataValue = function(component) {
  return component.getChild('field').getValue();
}

/**
 * @param {goog.ui.Component} component
 * @param {*} value
 */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.getLabelValue = function(component) {
  return component.getChild('label').getValue();
};

/**
 * @protected
 * @param {goog.ui.Control} container
 */
net.bluemind.contact.vcard.edit.ui.CoordinateField.prototype.handleLabelChanged = function(container) {
  container.getChild('field').setLabel(container.getChild('label').getCaption());
};
