/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.configfile.core;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;

public class CoreConfig {

	public static final String OVERRIDE_PATH = "/etc/bm/core.conf";

	public static class Pool {
		private Pool() {
		}

		public static final String TASKS_SIZE = "core.pool.tasks.size";
		public static final String TASKS_COMPLETED_TIMEOUT = "core.pool.tasks.completed-timeout";
		public static final String WORKER_SIZE = "core.pool.worker.size";
		public static final String EXECUTOR_SIZE = "core.pool.executor.size";
		public static final String EXECUTOR_COMPLETION_TIMEOUT = "core.pool.executor.completion-timeout";
	}

	public static class Io {
		private Io() {

		}

		public static final String WRITE_BUFFER = "core.io.write-buffer";
	}

	public static class SDS {
		private SDS() {
		}

		public static final String S3_MAX_CONNECTIONS = "core.sds.s3.max-connections";
		public static final String S3_TCP_KEEPALIVE = "core.sds.s3.tcp-keep-alive";
		public static final String S3_MAX_IDLE_TIME = "core.sds.s3.max-idle-time";
		public static final String READ_TIMEOUT = "core.sds.read-timeout";
		public static final String WRITE_TIMEOUT = "core.sds.write-timeout";
		public static final String S3_ACQUISITION_TIMEOUT = "core.sds.s3.acquisition-timeout";
	}

	public static class Sessions {
		private Sessions() {
		}

		public static final String STORAGE_PATH = "core.sessions.storage-path";
		public static final String IDLE_TIMEOUT = "core.sessions.idle-timeout";
	}

	public static class PostgreSQL {
		private PostgreSQL() {
		}

		public static final String STARTUP_TIMEOUT = "core.database.postgresql.startup-timeout";
		public static final String MAX_LIFETIME = "core.database.postgresql.max-lifetime";
		public static final String MAX_POOLSIZE = "core.database.postgresql.max-poolsize";
		public static final String SSL_MODE = "core.database.postgresql.sslmode";
		public static final String PREPARED_STATEMENT_CACHE_QUERIES = "core.database.postgresql.prepared-statement-cache-queries";
		public static final String PREPARED_STATEMENT_CACHE_SIZE_MIB = "core.database.postgresql.prepared-statement-cache-size-mib";
		public static final String PREFER_QUERY_MODE = "core.database.postgresql.prefer-query-mode";
		public static final String DEFAULT_ROW_FETCHSIZE = "core.database.postgresql.default-row-fetch-size";
		public static final String APPLICATION_NAME = "core.database.postgresql.application-name";
		public static final String REWRITE_BATCHED_INSERTS = "core.database.postgresql.rewrite-batched-inserts";
		public static final String PREPARE_THRESHOLD = "core.database.postgresql.prepare-threshold";
		public static final String LEAK_DETECTION_THRESHOLD = "core.database.postgresql.leak-detection-threshold";
		public static final String LEAK_DETECTION_ENABLED = "core.database.postgresql.leak-detection-enabled";
		public static final String IDLE_TIMEOUT = "core.database.postgresql.idle-timeout";
		public static final String MINIMUM_IDLE_CONNECTIONS = "core.database.postgresql.min-idle-connections";
		public static final String SOCKET_DIRECTORY = "core.database.postgresql.socket-directory";
	}

	public static class Redis {
		private Redis() {
		}

		public static final String SOCKET_PATH = "core.database.redis.socket-path";
	}

	public static class DataProtect {
		private DataProtect() {
		}

		public static final String POSTGRESQL_DUMP_ENABLED = "core.dataprotect.postgresql-dump-enabled";
		public static final String POSTGRESQL_DUMP_WITH_KAFKA_ENABLED = "core.dataprotect.postgresql-dump-with-kafka-enabled";
		public static final String SDS_DOWNLOAD_RETRIES = "core.dataprotect.sds-download-retries";
		public static final String SDS_DOWNLOAD_CONCURRENCY = "core.dataprotect.sds-download-concurrency";
		public static final String BACKUP_INDIVIDUAL_PART_TIME = "core.dataprotect.backup-individual-part-time";
		public static final String BACKUP_SDS_PART_TIME = "core.dataprotect.backup-sds-part-time";
	}

	public static class Cassandra {
		private Cassandra() {
		}

		public static final String PORT_TIMEOUT = "core.database.cassandra.port-timeout";
		public static final String REQUEST_TIMEOUT = "core.database.cassandra.request-timeout";

	}

	public static class Imip {
		private Imip() {
		}

		public static final String MAILSHARE_ENABLED = "core.imip.mailshare-enabled";

	}

	public static class Mapi {
		private Mapi() {
		}

		public static final String FT_BYTES_PER_SECOND = "mapi.fast-transfer.bytes-per-second";

	}

	public static class AclChangedNotification {
		private AclChangedNotification() {
		}

		public static final String QUEUE_SIZE = "core.aclChangedNotification.queue-size";
		public static final String DELAY = "core.aclChangedNotification.delay";
	}

	public static class Indexing {
		private Indexing() {
		}

		public static final String CONCURRENCY = "core.index.concurrency";

	}

	public static class Clone {
		private Clone() {
		}

		public static final String BROKEN_DIR_ENTRIES = "core.clone.broken-dir-entry-uids";
	}

	public static class TxOutbox {
		private TxOutbox() {
		}

		public static final String SLICE = "core.tx-outbox.flusher.slice";
		public static final String MGET = "core.tx-outbox.flusher.mget";
	}

	private static final Logger logger = LoggerFactory.getLogger(CoreConfig.class);
	private static Config instance = load();

	private CoreConfig() {
	}

	private static Config load() {
		Config conf = ConfigFactory.load(CoreConfig.class.getClassLoader(), "resources/application.conf");
		String configPath = System.getProperty("core.config.path");
		File local = configPath != null ? new File(configPath) : new File(OVERRIDE_PATH); // NOSONAR
		if (local.exists()) {
			try {
				Config parsed = ConfigFactory.parseFile(local);
				conf = parsed.withFallback(conf);
			} catch (ConfigException e) {
				logger.error("Invalid Core config file in '{}', ignored: {}", local, e.getMessage());
			}
		}
		return conf;
	}

	public static Config get() {
		return instance;
	}

}
