CREATE TYPE history_action_type AS ENUM (
    'Created',
    'Updated',
    'Deleted'
);

CREATE TABLE t_history_calendar_vevent (
  id BIGSERIAL,
  container_id int8 NOT NULL references t_container(id) on delete cascade,
  item_id int8 NOT NULL,
  date_timestamp timestamp without time zone NOT NULL,
  action_type history_action_type NOT NULL,
  ics_uid TEXT NOT NULL,
  author TEXT NOT NULL,
  origin TEXT,
  PRIMARY KEY(container_id, id)
) PARTITION BY HASH (container_id); 

CREATE INDEX IF NOT EXISTS t_history_calendar_vevent_container_item_id ON t_history_calendar_vevent(container_id, item_id);

DO LANGUAGE plpgsql
$$
DECLARE
    partition TEXT;
    partition_count INTEGER;
BEGIN
    SELECT INTO partition_count COALESCE(current_setting('bm.history_calendar_vevent_partitions', true)::integer, 256);
    FOR partition_key IN 0..(partition_count-1)
    LOOP
        partition := 't_history_calendar_vevent_' || partition_key;
        RAISE NOTICE 'CREATING t_history_calendar_vevent PARTITION %...', partition;
        EXECUTE 'CREATE TABLE ' || partition || ' PARTITION OF t_history_calendar_vevent FOR VALUES WITH (MODULUS '|| partition_count || ', REMAINDER ' || partition_key || ');';
    END LOOP;
END;
$$;


