/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.service;

import net.bluemind.calendar.api.IVFreebusy;
import net.bluemind.calendar.api.VFreebusy;
import net.bluemind.calendar.api.VFreebusyQuery;
import net.bluemind.core.api.date.BmDateTime;
import net.bluemind.core.api.fault.ServerFault;

public interface IInCoreFreebusy extends IVFreebusy {

	/**
	 * Exports the freebusy information optimized for a time based search targeting
	 * the time between from and to. Example: if from is T1400... to is T1600...,
	 * the search will try to only take into account events that take place between
	 * 2pm and 4pm. If the optimization cannot be applied, other slots may be
	 * returned as well
	 *
	 * @param query the standard query
	 * @param from  from time limit
	 * @param to    to time limit
	 * @return freebusy information
	 * @throws ServerFault
	 */
	public VFreebusy getTimeOptimized(VFreebusyQuery query, BmDateTime from, BmDateTime to) throws ServerFault;

}
